/*
 * This file contains all the function for home screen to work
 * */
#include <math.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"

#include "homeScreen.h"
#include "InitializeFunctions.h"

// variable for wave selection
char ch2 = 'n';
char ch1 = 'n';

// All the button defination for home screen
// Buttons for channel 1 wave selection
RectangularButton(sinButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 20, 69, 70,
                  40, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "SIN", 0, 0, 0, 0,
                  sinButCh1Func);
RectangularButton(sqrButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 120, 69, 70,
                  40, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "SQR", 0, 0, 0, 0,
                  sqrButCh1Func);
RectangularButton(triButCh1, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 220, 69, 70,
                  40, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "TRI", 0, 0, 0, 0,
                  triButCh1Func);

// Buttons for channel 2 wave selection
RectangularButton(sinButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 20, 149, 70,
                  40, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "SIN", 0, 0, 0, 0,
                  sinButCh2Func);
RectangularButton(sqrButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 120, 149, 70,
                  40, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "SQR", 0, 0, 0, 0,
                  sqrButCh2Func);
RectangularButton(triButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 220, 149, 70,
                  40, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, 0, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "TRI", 0, 0, 0, 0,
                  triButCh2Func);

// move to next screen and end the display button
RectangularButton(endButHS, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 195, 90,
                  45, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS, 0,
                  BUT_TEXT_COLOR, &g_sFontCm20, "END", 0, 0, 0, 0,
                  endButHSFunc);
RectangularButton(nextButHS, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 230, 195,
                  90, 45, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, "NEXT", 0, 0, 0, 0,
                  nextButHSFunc);

// functin for adding the required widgets on the home screen
void homeScreen()
{
    screenChar = 'a';
    clr_scrn_total();

    WidgetAdd(WIDGET_ROOT, (tWidget*) &sinButCh1);
    WidgetPaint((tWidget* )&sinButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &sqrButCh1);
    WidgetPaint((tWidget* )&sqrButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &triButCh1);
    WidgetPaint((tWidget* )&triButCh1);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &endButHS);
    WidgetPaint((tWidget* )&endButHS);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &nextButHS);
    WidgetPaint((tWidget* )&nextButHS);


    WidgetAdd(WIDGET_ROOT, (tWidget*) &sinButCh2);
    WidgetPaint((tWidget* )&sinButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &sqrButCh2);
    WidgetPaint((tWidget* )&sqrButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &triButCh2);
    WidgetPaint((tWidget* )&triButCh2);

    //makeRect(tRectangle * rect_name,short minX,short mixY, short maxX,short maxY,long colour,char * str)
    makeRect(&FuncGenRect, 0, 0, 319, 29, RECT_FOREGROUND_COLOR,
             "FUNCTION GENERATOR");
    makeRect(&channel1Rect, 0, 30, 60, 59, RECT_FOREGROUND_COLOR, "Channel1");
    makeRect(&channel2Rect, 0, 109, 60, 139, RECT_FOREGROUND_COLOR, "Channel2");
    makeRect(&homeRect, 90, 194, 229, 239, RECT_FOREGROUND_COLOR, "Home");

}

//onclick function of the SIN, SQR and TRI buttons
// for channel 1
void sinButCh1Func(tWidget *psWidget)
{
    ch1 = 'n';
    sinButCh1.ui32FillColor = BUT_PRESS;
    sqrButCh1.ui32FillColor = BUT_NORMAL;
    triButCh1.ui32FillColor = BUT_NORMAL;
}

void sqrButCh1Func(tWidget *psWidget)
{
    ch1 = 's';
    sinButCh1.ui32FillColor = BUT_NORMAL;
    sqrButCh1.ui32FillColor = BUT_PRESS;
    triButCh1.ui32FillColor = BUT_NORMAL;
}

void triButCh1Func(tWidget *psWidget)
{
    ch1 = 't';
    sinButCh1.ui32FillColor = BUT_NORMAL;
    sqrButCh1.ui32FillColor = BUT_NORMAL;
    triButCh1.ui32FillColor = BUT_PRESS;
}

// for channel 2
void sinButCh2Func(tWidget *psWidget)
{
    ch2 = 'n';
    sinButCh2.ui32FillColor = BUT_PRESS;
    sqrButCh2.ui32FillColor = BUT_NORMAL;
    triButCh2.ui32FillColor = BUT_NORMAL;
}

void sqrButCh2Func(tWidget *psWidget)
{
    ch2 = 's';
    sinButCh2.ui32FillColor = BUT_NORMAL;
    sqrButCh2.ui32FillColor = BUT_PRESS;
    triButCh2.ui32FillColor = BUT_NORMAL;
}

void triButCh2Func(tWidget *psWidget)
{
    ch2 = 't';
    sinButCh2.ui32FillColor = BUT_NORMAL;
    sqrButCh2.ui32FillColor = BUT_NORMAL;
    triButCh2.ui32FillColor = BUT_PRESS;
}

// onclick function for END button
void endButHSFunc(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &sinButCh1);
    WidgetRemove((tWidget*) &sqrButCh1);
    WidgetRemove((tWidget*) &triButCh1);
    WidgetRemove((tWidget*) &sinButCh2);
    WidgetRemove((tWidget*) &sqrButCh2);
    WidgetRemove((tWidget*) &triButCh2);
    WidgetRemove((tWidget*) &endButHS);
    WidgetRemove((tWidget*) &nextButHS);

    GrImageDraw(&sContext, g_DESElogoImage, 0, 0);
}

// onclick function for NEXT button
void nextButHSFunc(tWidget *psWidget)
{

    WidgetRemove((tWidget*) &sinButCh1);
    WidgetRemove((tWidget*) &sqrButCh1);
    WidgetRemove((tWidget*) &triButCh1);
    WidgetRemove((tWidget*) &sinButCh2);
    WidgetRemove((tWidget*) &sqrButCh2);
    WidgetRemove((tWidget*) &triButCh2);
    WidgetRemove((tWidget*) &endButHS);
    WidgetRemove((tWidget*) &nextButHS);

    clr_scrn_total();
    freqAmpSelScreenCh1();
}


